#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from OSEHRAHelper import PROMPT

#---------------------------------------------------------------------
# Create the System Manager
#---------------------------------------------------------------------

default_access_code = "SM1234"
temp_verify_code = "SM1234TMP!!"
init_verify_code = "SM1234!!"
def_service_section = "IRM"

def CreateSystemManager(VistA):
  default_access_code = "SM1234"
  temp_verify_code = "SM1234TMP!!"
  init_verify_code = "SM1234!!"
  def_service_section = "IRM"
  is_visn0 = "GEORGIA" == "CALIFORNIA" # assume CALIFONIA is using VISN0's data
  if is_visn0:
    temp_verify_code = init_verify_code
    def_service_section = "MEDICAL ADMIN"
  VistA.wait(PROMPT)
  VistA.write('S DUZ=1 D ^XUP')
  VistA.wait('Select OPTION NAME')
  VistA.write('EVE\r1')
  VistA.wait('Select Systems Manager Menu Option:')
  VistA.write('USER MANAGEMENT')
  VistA.wait('Select User Management Option:')
  VistA.write('ADD')
  VistA.wait(':')
  VistA.write('MANAGER,SYSTEM')
  while True:
    index = VistA.multiwait(['N[oO]//', 'INITIAL:'])
    if index != 1:
      VistA.write('Y')
      continue
    else:
      break
  VistA.write('SM')
  VistA.wait('SSN:')
  VistA.write('000000001')
  VistA.wait('SEX:')
  VistA.write('M')
  VistA.wait('NPI')
  VistA.write('')

  VistA.wait('NAME COMPONENTS')
  VistA.write('\r\r\r') # use all the default for NAME COMPONENTS and return back to main
  VistA.wait('jump to a specific field\.')
  VistA.write('C') # close command
  # go to PRIMARY MENU OPTION
  VistA.write('^PRIMARY MENU OPTION')
  VistA.write('EVE') # set to EVE
  VistA.wait("Choose 1-[\d] or '\^' to quit: ")
  VistA.write("1") # the first selection is EVE
  VistA.write('')
  # set up secondary menu
  VistA.write('^SECONDARY MENU')
  second_menu_options = ('OR PARAM COORDINATOR MENU',
                         'TIU IRM MAINTENANCE MENU',
                         'XPAR MENU TOOLS',
                         'DG REGISTER PATIENT')
  for option in second_menu_options:
    VistA.write(option)
    VistA.wait('// ')
    VistA.write('Y')
    VistA.write('')
    VistA.write('')
    VistA.wait('jump to a specific field\.')
    VistA.write('C') # close command
  # want to edit ACCESS CODE
  VistA.write('^Want to edit ACCESS CODE')
  VistA.write('Y')
  VistA.wait("Enter a new ACCESS CODE")
  VistA.write(default_access_code)
  VistA.wait('Please re-type the new code to show that I have it right:')
  VistA.write(default_access_code)
  # skip to verify code
  VistA.write('^Want to edit VERIFY CODE')
  VistA.write('Y')
  VistA.wait("Enter a new VERIFY CODE:")
  VistA.write(temp_verify_code)
  VistA.wait('Please re-type the new code to show that I have it right: ')
  VistA.write(temp_verify_code)
  # set up the multiple sign-on
  VistA.write('^MULTIPLE SIGN-ON')
  VistA.write('1') # select the first one
  VistA.write('1') # select allowed
  VistA.write('99') # set the limit to be 99
  # set up service/section
  VistA.write('^SERVICE/SECTION')
  VistA.write(def_service_section)
  VistA.wait('jump to a specific field\.')
  VistA.write('S')
  VistA.wait('jump to a specific field\.')
  VistA.write('E')
  # Print User Account Access Letter
  VistA.wait('User Account Access Letter')
  VistA.write('NO')
  VistA.wait('wish to allocate security keys?')
  VistA.write('Y')
  VistA.wait('Allocate key')
  VistA.write('XUMGR')
  VistA.wait('Another key')
  VistA.write('XUPROG\r1')
  VistA.wait('Another key')
  VistA.write('')
  VistA.wait('Another holder')
  VistA.write('')
  VistA.wait('YES//')
  VistA.write('')
  VistA.wait('mail groups?')
  VistA.write('\r')
  VistA.wait('Select User Management Option:')
  VistA.write('')
  VistA.wait('Select Systems Manager Menu Option:')
  VistA.write('')
  VistA.wait('Do you really want to halt?')
  VistA.write('YES')
  VistA.wait(PROMPT)
  VistA.IEN('NEW PERSON','MANAGER,SYSTEM')
  VistA.wait(PROMPT)
  VistA.write('S DUZ=' + VistA.IENumber + ' S $P(^VA(200,DUZ,0),"^",4)="@"')
  #
  # Right away do a first login, since VistA will
  # require the user to change its verify code in
  # the first login. In this way we know what the
  # final verify code will be.
  #
  VistA.wait(PROMPT)
  VistA.write('D ^ZU')
  VistA.wait('ACCESS CODE:')
  VistA.write(default_access_code)
  VistA.wait('VERIFY CODE:')
  VistA.write(temp_verify_code)
  #
  # Dialog changing the temporary verify code
  #
  if not is_visn0:
    VistA.wait('Please enter your CURRENT verify code:')
    VistA.write(temp_verify_code)
    VistA.wait('Enter a new VERIFY CODE:')
    VistA.write(init_verify_code)
    VistA.wait('Please re-type the new code to show that I have it right:')
    VistA.write(init_verify_code)
  VistA.wait('Select TERMINAL TYPE NAME:')
  VistA.write('')
  #
  #  At this point we left in the menu prompt:
  #
  #    "Select Systems Manager Menu Option:"
  #

def SignInAsSysmtemManager(VistA):
  VistA.wait(PROMPT)
  VistA.write('D ^ZU')
  VistA.wait('ACCESS CODE:')
  VistA.write(default_access_code)
  VistA.wait('VERIFY CODE:')
  VistA.write(init_verify_code)
  VistA.wait('Select TERMINAL TYPE NAME:')
  VistA.write('')
